/*
 * Java
 *
 * Copyright 2018-2021 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.kf;

import ej.annotation.Nullable;
import ej.kf.Feature;
import ej.kf.FeatureStateListener;
import ej.kf.Kernel;
import ej.kf.ResourceControlListener;

/**
 * Thread in charge of calling the {@link FeatureStateListener} and the {@link ResourceControlListener} for the stopped features.
 */
public class FeatureFinalizer extends Thread {

	public static @Nullable Thread FeatureFinalizerThread;

	public FeatureFinalizer(){
		super("FeatureFinalizer");
	}

	public static void initialize(){
		FeatureFinalizer featureFinalizer = new FeatureFinalizer();
		FeatureFinalizerThread = featureFinalizer;
		featureFinalizer.setDaemon(true);
		// Don't use '+' on strings to avoid compiler optimization. We want to reduce flash consumption.
		String finalizerPriorityProperty = new StringBuilder(Kernel.KF_PROPERTY_PREFIX).append("finalizer.priority").toString();
		featureFinalizer.setPriority(Integer.getInteger(finalizerPriorityProperty, Thread.NORM_PRIORITY));
		featureFinalizer.start();
	}

	@Override
	public void run(){
		while(true){
			Feature feature = KernelNatives.getNextStoppedFeatureToUpdate();
			if(feature != null){
				feature.updateStopStep();
			}
		}
	}

}
