/*
 * Java
 *
 * Copyright 2022 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.kf;

import ej.annotation.Nullable;

/**
 * Common class for exceptions with a error code
 */
public abstract class ExceptionWithErrorCode extends Exception {

	protected final int kind;

	public ExceptionWithErrorCode() {
		// API constructor
		kind = 0;
	}

	public ExceptionWithErrorCode(int kind) {
		this(kind, null);
	}

	public ExceptionWithErrorCode(int kind, @Nullable String message) {
		super(message);
		this.kind = kind;
	}


	@Override
	@Nullable
	public String getMessage() {
		String message = super.getMessage();
		return "code="+kind+(message==null?"":":"+message);
	}

}