/*
 * Java
 *
 * Copyright 2013-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.kf;

import ej.kf.Feature;
import ej.kf.UncaughtExceptionHandler;

/**
 * Default implementation: print on error output stream.
 */
public class DefaultExceptionHandler implements UncaughtExceptionHandler{

	@Override
	public void uncaughtException(Feature f, Thread t, Throwable e) {
		Thread.UncaughtExceptionHandler h = t.getUncaughtExceptionHandler();
		if (h == null) {
			h = Thread.getDefaultUncaughtExceptionHandler();
		}
		if (h == null) {
			// legacy default behavior
			System.err.println(
					"Uncaught exception thrown in Feature " + f.getName() + " (" + f.getProvider().toString() + "):");
			e.printStackTrace();
		}
		else {
			h.uncaughtException(t, e);
		}

	}

}
