/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth.tools;

import ej.bon.Immutables;

/**
 * Not in API.
 */
public class HexTools {

	private static final String HEX_TABLE_IMMUTABLE = "ej.bluetooth.HEX_TABLE";
	private static final char[] HEX_TABLE = (char[]) Immutables.get(HEX_TABLE_IMMUTABLE);

	private HexTools() {
		// private constructor
	}

	public static void byteToString(byte b, char[] string, int stringIndex) {
		int value = (b & 0xFF);
		string[stringIndex + 0] = HEX_TABLE[value >> 4];
		string[stringIndex + 1] = HEX_TABLE[value & 0xF];
	}

	public static byte stringToByte(String string, int stringIndex) {
		char c0 = string.charAt(stringIndex);
		char c1 = string.charAt(stringIndex + 1);
		return (byte) (getHexValue(c0) << 4 | getHexValue(c1));
	}

	private static int getHexValue(char c) {
		if (c >= '0' && c <= '9') {
			return (c - '0');
		} else if (c >= 'a' && c <= 'f') {
			return (c - 'a') + 0xA;
		} else if (c >= 'A' && c <= 'F') {
			return (c - 'A') + 0xA;
		} else {
			throw new IllegalArgumentException();
		}
	}
}
