/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth.tools;

import ej.bon.Util;

/**
 * Not in API.
 */
public class ArrayTools {

	private ArrayTools() {
		// private constructor
	}

	@SuppressWarnings("unchecked")
	public static <T> T[] append(T[] array, T element) {
		int arrayLength = array.length; // can throw NullPointerException
		T[] newArray = Util.newArray((Class<T[]>) array.getClass(), arrayLength + 1);
		newArray[arrayLength] = element;
		System.arraycopy(array, 0, newArray, 0, arrayLength);
		return newArray;
	}

	@SuppressWarnings("unchecked")
	public static <T> T[] insert(T[] array, T element, int index) {
		int arrayLength = array.length; // can throw NullPointerException
		T[] newArray = Util.newArray((Class<T[]>) array.getClass(), arrayLength + 1);
		newArray[index] = element;
		System.arraycopy(array, 0, newArray, 0, index);
		System.arraycopy(array, index, newArray, index + 1, arrayLength - index);
		return newArray;
	}

	@SuppressWarnings("unchecked")
	public static <T> T[] remove(T[] array, int index) {
		int arrayLength = array.length; // can throw NullPointerException
		T[] newArray = Util.newArray((Class<T[]>) array.getClass(), arrayLength - 1);
		System.arraycopy(array, 0, newArray, 0, index);
		System.arraycopy(array, index + 1, newArray, index, arrayLength - 1 - index);
		return newArray;
	}

	public static byte[] readBytes(byte[] array, int offset, int length) {
		byte[] newArray = new byte[length];
		System.arraycopy(array, offset, newArray, 0, length);
		return newArray;
	}
}
