/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth.listeners.impl;

import ej.bluetooth.BluetoothAttribute;
import ej.bluetooth.BluetoothCharacteristic;
import ej.bluetooth.BluetoothConnection;
import ej.bluetooth.BluetoothStatus;
import ej.bluetooth.listeners.LocalServiceListener;

public class DefaultLocalServiceListener implements LocalServiceListener {

	private static final byte DEFAULT_RESPONSE = BluetoothStatus.REQUEST_NOT_SUPPORTED;

	@Override
	public void onReadRequest(BluetoothConnection connection, BluetoothAttribute attribute) {
		connection.sendReadResponse(attribute, DEFAULT_RESPONSE, new byte[0]);
	}

	@Override
	public void onReadBlobRequest(BluetoothConnection connection, BluetoothAttribute attribute, int offset) {
		connection.sendReadResponse(attribute, DEFAULT_RESPONSE, new byte[0]);
	}

	@Override
	public void onWriteRequest(BluetoothConnection connection, BluetoothAttribute attribute, byte[] value) {
		connection.sendWriteResponse(attribute, DEFAULT_RESPONSE);
	}

	@Override
	public void onPrepareWriteRequest(BluetoothConnection connection, BluetoothAttribute attribute, byte[] value,
			int offset) {
		connection.sendPrepareWriteResponse(attribute, DEFAULT_RESPONSE, value, offset);
	}

	@Override
	public void onExecuteWriteRequest(BluetoothConnection connection, BluetoothAttribute attribute, boolean execute) {
		connection.sendExecuteWriteResponse(attribute, DEFAULT_RESPONSE);
	}

	@Override
	public void onNotificationSent(BluetoothConnection connection, BluetoothCharacteristic characteristic,
			boolean success) {
		// do nothing
	}
}
