/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth.listeners.impl;

import ej.bluetooth.BluetoothAddress;
import ej.bluetooth.BluetoothConnection;
import ej.bluetooth.BluetoothService;
import ej.bluetooth.listeners.ConnectionListener;

public class DefaultConnectionListener implements ConnectionListener {

	@Override
	public void onAdvertisementCompleted() {
		// do nothing
	}

	@Override
	public void onScanCompleted() {
		// do nothing
	}

	@Override
	public void onScanResult(BluetoothAddress address, byte[] advertisementData, int rssi) {
		// do nothing
	}

	@Override
	public void onConnectFailed(BluetoothAddress address) {
		// do nothing
	}

	@Override
	public void onConnected(BluetoothConnection connection) {
		connection.discoverServices();
	}

	@Override
	public void onDisconnected(BluetoothConnection connection) {
		// do nothing
	}

	@Override
	public void onPairRequest(BluetoothConnection connection) {
		connection.sendPairResponse(false);
	}

	@Override
	public void onPairCompleted(BluetoothConnection connection, boolean success) {
		// do nothing
	}

	@Override
	public void onPasskeyRequest(BluetoothConnection connection) {
		connection.sendPasskeyResponse(false, 0);
	}

	@Override
	public void onPasskeyGenerated(BluetoothConnection connection, int passkey) {
		// do nothing
	}

	@Override
	public void onDiscoveryResult(BluetoothConnection connection, BluetoothService service) {
		// do nothing
	}

	@Override
	public void onDiscoveryCompleted(BluetoothConnection connection) {
		// do nothing
	}
}
