/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth.listeners;

import ej.bluetooth.BluetoothAttribute;
import ej.bluetooth.BluetoothCharacteristic;
import ej.bluetooth.BluetoothConnection;

public interface RemoteServiceListener {

	void onReadCompleted(BluetoothConnection connection, BluetoothAttribute attribute, byte status, byte[] value);

	void onWriteCompleted(BluetoothConnection connection, BluetoothAttribute attribute, byte status);

	void onNotificationReceived(BluetoothConnection connection, BluetoothCharacteristic characteristic, byte[] value);
}
