/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth.listeners;

import ej.bluetooth.BluetoothAttribute;
import ej.bluetooth.BluetoothCharacteristic;
import ej.bluetooth.BluetoothConnection;

public interface LocalServiceListener {

	void onReadRequest(BluetoothConnection connection, BluetoothAttribute attribute);

	void onReadBlobRequest(BluetoothConnection connection, BluetoothAttribute attribute, int offset);

	void onWriteRequest(BluetoothConnection connection, BluetoothAttribute attribute, byte[] value);

	void onPrepareWriteRequest(BluetoothConnection connection, BluetoothAttribute attribute, byte[] value, int offset);

	void onExecuteWriteRequest(BluetoothConnection connection, BluetoothAttribute attribute, boolean execute);

	void onNotificationSent(BluetoothConnection connection, BluetoothCharacteristic characteristic, boolean success);
}
