/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth.listeners;

import ej.bluetooth.BluetoothAddress;
import ej.bluetooth.BluetoothConnection;
import ej.bluetooth.BluetoothService;

public interface ConnectionListener {

	void onAdvertisementCompleted();

	void onScanCompleted();

	void onScanResult(BluetoothAddress address, byte[] advertisementData, int rssi);

	void onConnectFailed(BluetoothAddress address);

	void onConnected(BluetoothConnection connection);

	void onDisconnected(BluetoothConnection connection);

	void onPairRequest(BluetoothConnection connection);

	void onPairCompleted(BluetoothConnection connection, boolean success);

	void onPasskeyRequest(BluetoothConnection connection);

	void onPasskeyGenerated(BluetoothConnection connection, int passkey);

	void onDiscoveryResult(BluetoothConnection connection, BluetoothService service);

	void onDiscoveryCompleted(BluetoothConnection connection);
}
