/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth;

public class BluetoothStatus {

	public static final byte OK = 0x00;
	public static final byte INVALID_HANDLE = 0x01;
	public static final byte READ_NOT_PERMITTED = 0x02;
	public static final byte WRITE_NOT_PERMITTED = 0x03;
	public static final byte INVALID_PDU = 0x04;
	public static final byte INSUFFICIENT_AUTHENTICATION = 0x05;
	public static final byte REQUEST_NOT_SUPPORTED = 0x06;
	public static final byte INVALID_OFFSET = 0x07;
	public static final byte INSUFFICIENT_AUTHORIZATION = 0x08;
	public static final byte PREPARE_QUEUE_FULL = 0x09;
	public static final byte ATTRIBUTE_NOT_FOUND = 0x0A;
	public static final byte ATTRIBUTE_NOT_LONG = 0x0B;
	public static final byte INSUFFICIENT_KEY_SIZE = 0x0C;
	public static final byte INVALID_VALUE_LENGTH = 0x0D;
	public static final byte UNLIKELY = 0x0E;
	public static final byte INSUFFICIENT_ENCRYPTION = 0x0F;
	public static final byte UNSUPPORTED_GROUP_TYPE = 0x10;
	public static final byte INSUFFICIENT_RESOURCES = 0x11;
	public static final byte WRITE_REQUEST_REJECTED = (byte) 0xFC;
	public static final byte CCC_DESCRIPTOR_IMPROPERLY_CONFIGURED = (byte) 0xFD;
	public static final byte PROCEDURE_ALREADY_IN_PROGRESS = (byte) 0xFE;
	public static final byte OUT_OF_RANGE = (byte) 0xFF;

	private BluetoothStatus() {
		// private constructor
	}
}
