/*
 * Java
 *
 * Copyright 2019-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth;

public class BluetoothScanFilter {

	private static final byte ACTION_NONE = 0;
	private static final byte ACTION_FIELD_EXISTS = 1;
	private static final byte ACTION_FIELD_EQUALS = 2;
	private static final byte ACTION_FIELD_STARTS_WITH = 3;

	private final byte action;
	private final byte type;
	private final byte[] data;

	/**
	 * Not in API.
	 */
	private BluetoothScanFilter(byte action, byte type, byte[] data) {
		this.action = action;
		this.type = type;
		this.data = data;
	}

	public static BluetoothScanFilter noFilter() {
		return new BluetoothScanFilter(ACTION_NONE, (byte) 0xFF, new byte[0]);
	}

	public static BluetoothScanFilter fieldExists(byte type) {
		return new BluetoothScanFilter(ACTION_FIELD_EXISTS, type, new byte[0]);
	}

	public static BluetoothScanFilter fieldEquals(byte type, byte[] data) {
		return new BluetoothScanFilter(ACTION_FIELD_EQUALS, type, data);
	}

	public static BluetoothScanFilter fieldStartsWith(byte type, byte[] data) {
		return new BluetoothScanFilter(ACTION_FIELD_STARTS_WITH, type, data);
	}

	/**
	 * Not in API.
	 */
	public byte getAction() {
		return this.action;
	}

	/**
	 * Not in API.
	 */
	public byte getType() {
		return this.type;
	}

	/**
	 * Not in API.
	 */
	public byte[] getData() {
		return this.data;
	}
}
