/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth;

public class BluetoothPermissions {

	public static final byte NONE = 0x00;

	public static final byte READ = 0x01;
	public static final byte READ_ENCRYPT = 0x02;
	public static final byte READ_AUTH = 0x04;

	public static final byte WRITE = 0x08;
	public static final byte WRITE_ENCRYPT = 0x10;
	public static final byte WRITE_AUTH = 0x20;

	public static final byte RW = READ | WRITE;
	public static final byte RW_ENCRYPT = READ_ENCRYPT | WRITE_ENCRYPT;
	public static final byte RW_AUTH = READ_AUTH | WRITE_AUTH;

	private BluetoothPermissions() {
		// private constructor
	}
}
