/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth;

import ej.annotation.Nullable;

/**
 * Not in API.
 */
public class BluetoothNatives {

	private BluetoothNatives() {
		// private constructor
	}

	public static native int waitEvent(byte[] buffer, int bufferLength);

	public static native boolean enable();

	public static native void disable();

	public static native boolean addService(byte[] service, short[] handles);

	public static native boolean startScanning(byte filterAction, byte filterType, byte[] filterData,
			int filterDataSize);

	public static native boolean stopScanning();

	public static native boolean startAdvertising(byte[] advertisementData, int advertisementDataSize);

	public static native boolean stopAdvertising();

	public static native boolean connect(byte[] deviceAddress);

	public static native boolean disconnect(short connHandle);

	public static native boolean sendPairRequest(short connHandle);

	public static native boolean sendPairResponse(short connHandle, boolean accept);

	public static native boolean sendPasskeyResponse(short connHandle, boolean accept, int passkey);

	public static native boolean discoverServices(short connHandle, @Nullable byte[] uuid);

	public static native boolean sendReadRequest(short connHandle, short attributeHandle);

	public static native boolean sendWriteRequest(short connHandle, short attributeHandle, byte[] value, int valueSize,
			boolean noResponse);

	public static native boolean sendReadResponse(short connHandle, short attributeHandle, byte status, byte[] value,
			int valueSize);

	public static native boolean sendWriteResponse(short connHandle, short attributeHandle, byte status);

	public static native boolean sendPrepareWriteResponse(short connHandle, short attributeHandle, byte status,
			byte[] value, int valueSize, int offset);

	public static native boolean sendExecuteWriteResponse(short connHandle, short attributeHandle, byte status);

	public static native boolean sendNotification(short connHandle, short attributeHandle, byte[] value, int valueSize,
			boolean confirm);
}
