/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth;

/**
 * Not in API.
 */
public class BluetoothEventTypes {

	/** On scan result. */
	public static final byte GAP_SCAN_RESULT = 1;

	/** On end of scan. */
	public static final byte GAP_SCAN_COMPLETED = 2;

	/** On end of advertising. */
	public static final byte GAP_ADVERTISEMENT_COMPLETED = 3;

	/** On unsuccessful connection. */
	public static final byte GAP_CONNECT_FAILED = 4;

	/** On successful connection. */
	public static final byte GAP_CONNECTED = 5;

	/** On disconnection. */
	public static final byte GAP_DISCONNECTED = 6;

	/** On pair request. */
	public static final byte GAP_PAIR_REQUEST = 7;

	/** On pair completed. */
	public static final byte GAP_PAIR_COMPLETED = 8;

	/** On passkey request. */
	public static final byte GAP_PASSKEY_REQUEST = 9;

	/** On passkey generated. */
	public static final byte GAP_PASSKEY_GENERATED = 10;

	/** On discovery of a service. */
	public static final byte GATTC_DISCOVERY_RESULT = 11;

	/** On end of service discovery. */
	public static final byte GATTC_DISCOVERY_COMPLETED = 12;

	/** On attribute read completed. */
	public static final byte GATTC_READ_COMPLETED = 13;

	/** On attribute write completed. */
	public static final byte GATTC_WRITE_COMPLETED = 14;

	/** On attribute notification or indication received. */
	public static final byte GATTC_NOTIFICATION_RECEIVED = 15;

	/** On attribute read request. */
	public static final byte GATTS_READ_REQUEST = 16;

	/** On attribute write request. */
	public static final byte GATTS_WRITE_REQUEST = 17;

	/** On notification or indication sent. */
	public static final byte GATTS_NOTIFICATION_SENT = 18;

	/** On execute write request. */
	public static final byte GATTS_EXECUTE_WRITE_REQUEST = 19;

	private BluetoothEventTypes() {
		// private constructor
	}
}
