/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth;

public class BluetoothDescriptor extends BluetoothAttribute {

	private final BluetoothCharacteristic characteristic;

	public BluetoothDescriptor(BluetoothUuid uuid, short handle, BluetoothCharacteristic characteristic) {
		super(uuid, handle);
		this.characteristic = characteristic;
	}

	public BluetoothCharacteristic getCharacteristic() {
		return this.characteristic;
	}

	@Override
	public BluetoothService getService() {
		return this.characteristic.getService();
	}

	/**
	 * Not in API.
	 */
	@Override
	public boolean useWriteWithoutResponse() {
		return false;
	}
}
