/*
 * Java
 *
 * Copyright 2019-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth;

public class BluetoothDataTypes {

	public static final byte FLAGS = 0x01;
	public static final byte SERVICE_UUID16_INCOMPLETE_LIST = 0x02;
	public static final byte SERVICE_UUID16_COMPLETE_LIST = 0x03;
	public static final byte SERVICE_UUID32_INCOMPLETE_LIST = 0x04;
	public static final byte SERVICE_UUID32_COMPLETE_LIST = 0x05;
	public static final byte SERVICE_UUID128_INCOMPLETE_LIST = 0x06;
	public static final byte SERVICE_UUID128_COMPLETE_LIST = 0x07;
	public static final byte SHORTENED_LOCAL_NAME = 0x08;
	public static final byte COMPLETE_LOCAL_NAME = 0x09;
	public static final byte TX_POWER_LEVEL = 0x0A;
	public static final byte SLAVE_CONNECTION_INTERVAL_RANGE = 0x12;
	public static final byte SERVICE_SOLICITATION_UUID16_LIST = 0x14;
	public static final byte SERVICE_SOLICITATION_UUID128_LIST = 0x15;
	public static final byte SERVICE_DATA_UUID16 = 0x16;
	public static final byte PUBLIC_TARGET_ADDRESS = 0x17;
	public static final byte RANDOM_TARGET_ADDRESS = 0x18;
	public static final byte APPEARANCE = 0x19;
	public static final byte ADVERTISING_INTERVAL = 0x1A;
	public static final byte SERVICE_SOLICITATION_UUID32_LIST = 0x1F;
	public static final byte SERVICE_DATA_UUID32 = 0x20;
	public static final byte SERVICE_DATA_UUID128 = 0x21;
	public static final byte URI = 0x24;
	public static final byte LE_SUPPORTED_FEATURES = 0x27;
	public static final byte MANUFACTURER_SPECIFIC_DATA = (byte) 0xFF;

	private BluetoothDataTypes() {
		// private constructor
	}
}
