/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth;

import ej.bluetooth.tools.ArrayTools;

public class BluetoothCharacteristic extends BluetoothAttribute {

	private final byte properties;
	private final BluetoothService service;

	private BluetoothDescriptor[] descriptors;

	/**
	 * Not in API.
	 */
	public BluetoothCharacteristic(BluetoothUuid uuid, byte properties, short handle, BluetoothService service) {
		super(uuid, handle);
		this.properties = properties;
		this.service = service;
		this.descriptors = new BluetoothDescriptor[0];
	}

	/**
	 * Not in API.
	 */
	public void addDescriptor(BluetoothDescriptor descriptor) {
		this.descriptors = ArrayTools.append(this.descriptors, descriptor);
	}

	public byte getProperties() {
		return this.properties;
	}

	public int getNumDescriptors() {
		return this.descriptors.length;
	}

	public BluetoothDescriptor getDescriptor(int index) {
		BluetoothDescriptor descriptor = this.descriptors[index];
		assert (descriptor != null);
		return descriptor;
	}

	/**
	 * Not in API.
	 */
	public BluetoothDescriptor[] getDescriptors() {
		return this.descriptors; // NOSONAR - don't get a copy
	}

	@Override
	public BluetoothService getService() {
		return this.service;
	}

	/**
	 * Not in API.
	 */
	@Override
	public boolean useWriteWithoutResponse() {
		return (this.properties & BluetoothProperties.WRITE_NO_RESPONSE) != 0;
	}
}
