/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth;

public abstract class BluetoothAttribute {

	private final BluetoothUuid uuid;
	private final short handle;

	/**
	 * Not in API.
	 */
	public BluetoothAttribute(BluetoothUuid uuid, short handle) {
		this.uuid = uuid;
		this.handle = handle;
	}

	public BluetoothUuid getUuid() {
		return this.uuid;
	}

	/**
	 * Not in API.
	 */
	public short getHandle() {
		return this.handle;
	}

	public abstract BluetoothService getService();

	/**
	 * Not in API.
	 */
	public abstract boolean useWriteWithoutResponse();
}
