/*
 * Java
 *
 * Copyright 2014 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.sni;

import com.is2t.hil.HIL;
import com.is2t.hil.NativeInterface;

/**
 * Simple Native Interface utility methods.
 */
public class SNI {

	/**
	 * Transforms a Java String into a C String.<br>
	 * The platform default encoding is used to transform Java characters into C characters.<br>
	 * The created C String is a NULL terminated String (ends with '\0'). The <code>cString</code> array length
	 * must be at least <code>javaString.length()+1</code>.<br>
	 * The content of the given <code>cString</code> array is automatically flushed with the method {@link NativeInterface#flushContent(Object, int, int)}.
	 * Only <code>javaString.length()</code> bytes are flushed.
	 * 
	 * @param javaString the Java String
	 * @param cString byte array which contains the C String.
	 * 
	 * @throws IllegalArgumentException if javaString or cString is null
	 * @throws ArrayIndexOutOfBoundsException if cString is too small to contain the string
	 */
	public static void toCString(String javaString, byte[] cString) {
		HIL.getInstance().toCString(javaString, cString);
	}
	
	/**
	 * Transforms a C String into a Java String,
	 * using platform default encoding.
	 * The C String must be NULL terminated.<br>
	 * The content of the given <code>cString</code> is automatically refreshed with the method {@link NativeInterface#refreshContent(Object)}.
	 * 
	 * @param cString byte array which contains the C String
	 * @return a new Java String.
	 * 
	 * @throws IllegalArgumentException if cString is null or its length is < 1
	 * @throws IllegalArgumentException if cString is not NULL terminated.
	 */
	public static String toJavaString(byte[] cString) {
		return HIL.getInstance().toJavaString(cString);
	}

}
