/*
 * Java
 *
 * Copyright 2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.sni;

import java.io.Closeable;

import com.is2t.hil.NativeInterface;


/**
 * Wrapper to a resource (a {@link Closeable}) that has been registered into the simulator using
 * {@link NativeInterface#registerNativeResource(Closeable)}.
 * <p>
 * A {@link NativeResource} is identified by an ID that can be retrieved by calling {@link #getResourceId()}.
 * <p>
 * The method {@link NativeInterface#getNativeResource(int)} can be used to find a {@link NativeResource} from
 * its ID.
 * <p>
 * Use the method {@link NativeInterface#getNativeResourceCloseFunctionId()} to retrieve a close function ID that
 * can be passed by the application to the method <code>SNI.closeOnGC()</code>.
 * 
 * @see NativeInterface#registerNativeResource(Closeable)
 */
public interface NativeResource {

	/**
	 * Returns the ID of this native resource. The ID is a positive integer different from 0 assigned by the simulator.
	 */
	public int getResourceId();

	/**
	 * Returns the {@link Closeable} that has been given to the method {@link NativeInterface#registerNativeResource(Closeable)}.
	 */
	public Closeable getResource();

}
