/*
 * Java
 *
 * Copyright 2017 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.sni;

import java.io.IOException;

/**
 * {@link IOException} subclass that may be thrown from an SNI native using
 * <code>SNI_throwNativeIOException()</code> function.
 */
public class NativeIOException extends IOException {

	private final int errorCode;//VM Known


	/**
	 * Constructs a new {@link NativeIOException} with the specified error code and detail
	 * message.
	 * 
	 * @param errorCode the error code. The error code is saved for later retrieval by
	 * the {@link #getErrorCode()} method.
	 * 
	 * @param errorMessage the detail message. The detail message is saved for later retrieval
	 * by the {@link #getMessage()} method.
	 */
	public NativeIOException(int errorCode, String errorMessage){
		super(errorMessage);
		this.errorCode = errorCode;
	}

	/**
	 * Constructs a new {@link NativeIOException} with the specified error code, detail message and cause.
	 * 
	 * @param errorCode the error code. The error code is saved for later retrieval by
	 * the {@link #getErrorCode()} method.
	 * 
	 * @param errorMessage the detail message. The detail message is saved for later retrieval
	 * by the {@link #getMessage()} method.
	 * 
	 * @param cause the cause (which is saved for later retrieval by the {@link #getCause()} method).
	 * (A <tt>null</tt> value is permitted, and indicates that the cause is nonexistent or unknown.)
	 */
	public NativeIOException(int errorCode, String errorMessage, Throwable cause){
		super(errorMessage, cause);
		this.errorCode = errorCode;
	}

	/**
	 * Returns the error code of this {@link NativeIOException}.
	 * @return the error code of this {@link NativeIOException} instance.
	 */
	public int getErrorCode(){
		return errorCode;
	}

}
