/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.hil;

import java.util.ServiceLoader;

/**
 * An interface for simulator start listeners. When the simulator starts it calls the {@link #start()} method.
 * <p>
 * To register a {@link StartListener}, declare it as a service provider (see {@link ServiceLoader}). Place a file named
 * <code>com.is2t.hil.StartListener</code> in the resource directory <code>META-INF/services</code>. This file must contains
 * a list of fully-qualified names of concrete provider classes, one per line.
 */
public interface StartListener {

	/**
	 * Called when the simulator is starting.
	 */
	public void start() ;

}
