/**
 * Java
 * 
 * Copyright 2012-2013 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.hil;

import java.util.Iterator;
import java.util.ServiceLoader;

public final class HIL {

	private static NativeInterface singleton;

	/**
	 * @return the {@link NativeInterface} instance.
	 */
	public static NativeInterface getInstance() {
		if (singleton == null) {
			ServiceLoader<NativeInterface> hilLoader = ServiceLoader.load(NativeInterface.class);
			Iterator<NativeInterface> it = hilLoader.iterator();
			if (!it.hasNext()) {
				throw new RuntimeException("Unable to find a " + NativeInterface.class.getName() + " Implementation.");
			}
			singleton = it.next();
		}
		return singleton;
	}

}
