/*
 * Java
 *
 * Copyright 2015-2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microui.event;

import ej.annotation.Nullable;
import ej.microui.AbstractPermission;

/**
 * microUI-API
 */
@SuppressWarnings("nls")
public class EventPermission extends AbstractPermission {

	private static final long serialVersionUID = 1L;

	/* package */ static final String PERMISSION_SET = "set";

	private final @Nullable EventGenerator gen;

	/**
	 * microUI-API
	 *
	 * @param gen
	 *            microUI-API
	 *
	 * @deprecated use {@link #EventPermission(EventGenerator, String)}
	 */
	@Deprecated
	public EventPermission(@Nullable EventGenerator gen) {
		this(gen, PERMISSION_SET /* backward compatibility */);
	}

	/**
	 * microUI-API
	 *
	 * @param gen
	 *            microUI-API
	 * @param permission
	 *            a permission
	 */
	public EventPermission(@Nullable EventGenerator gen, String permission) {
		super(permission);
		this.gen = gen;
	}

	/**
	 * microUI-API
	 *
	 * @return microUI-API
	 */
	public @Nullable EventGenerator getEventGenerator() {
		return this.gen;
	}

	@Override
	public boolean equals(Object obj) {
		// sonar requires an explicit implementation of equals()
		// but ignore the check of the generator
		return super.equals(obj);
	}

	@Override
	public int hashCode() {
		// sonar requires an explicit implementation of equals() (and so hashCode() too)
		return super.hashCode();
	}
}
