/*
 * Java
 *
 * Copyright 2014-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microui.event;

/**
 * MICROWT-API An event handler is intended to receive and handle events.
 * <p>
 * In the MVC pattern it is the controller.
 */
public interface EventHandler {

	/**
	 * MICROWT-API Handles an event.
	 *
	 * @param event
	 *            the event to handle.
	 * @return <code>true</code> if the event is consumed, <code>false</code> otherwise.
	 */
	boolean handleEvent(int event);

}
