/*
 * Java
 *
 * Copyright 2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microui.display;

import ej.bon.ByteArray;
import ej.bon.Constants;
import ej.microui.MicroUIProperties;

/**
 *
 */
public class Tools {

	private Tools() {
		// not entry point
	}

	public static void setInt(byte[] graphicalEngineMetadata, int offset, int value) {
		if (Constants.getBoolean(MicroUIProperties.CONSTANT_ON_S3)) {
			// ByteArray.writeInt() always uses emb platform endianness whereas the
			// simulator can have another endianness
			ByteArray.writeInt(graphicalEngineMetadata, offset, value, ByteArray.BIG_ENDIAN);
		} else {
			ByteArray.writeInt(graphicalEngineMetadata, offset, value);
		}
	}

	public static void setChar(byte[] graphicalEngineMetadata, int offset, char value) {
		if (Constants.getBoolean(MicroUIProperties.CONSTANT_ON_S3)) {
			// ByteArray.writeShort() always uses emb platform endianness whereas the
			// simulator can have another endianness
			ByteArray.writeShort(graphicalEngineMetadata, offset, value, ByteArray.BIG_ENDIAN);
		} else {
			ByteArray.writeShort(graphicalEngineMetadata, offset, value);
		}
	}

	public static int getInt(byte[] graphicalEngineMetadata, int offset) {
		if (Constants.getBoolean(MicroUIProperties.CONSTANT_ON_S3)) {
			// ByteArray.readInt() always uses emb platform endianness whereas the simulator
			// can have another endianness
			return ByteArray.readInt(graphicalEngineMetadata, offset, ByteArray.BIG_ENDIAN);
		} else {
			return ByteArray.readInt(graphicalEngineMetadata, offset);
		}
	}

	public static short getShort(byte[] graphicalEngineMetadata, int offset) {
		if (Constants.getBoolean(MicroUIProperties.CONSTANT_ON_S3)) {
			// ByteArray.readShort() always uses emb platform endianness whereas the
			// simulator can have another endianness
			return ByteArray.readShort(graphicalEngineMetadata, offset, ByteArray.BIG_ENDIAN);
		} else {
			return ByteArray.readShort(graphicalEngineMetadata, offset);
		}
	}

	public static char getChar(byte[] graphicalEngineMetadata, int offset) {
		if (Constants.getBoolean(MicroUIProperties.CONSTANT_ON_S3)) {
			// ByteArray.readChar() always uses emb platform endianness whereas the
			// simulator can have another endianness
			return ByteArray.readChar(graphicalEngineMetadata, offset, ByteArray.BIG_ENDIAN);
		} else {
			return ByteArray.readChar(graphicalEngineMetadata, offset);
		}
	}

	public static int getUnsignedByte(byte[] graphicalEngineMetadata, int offset) {
		if (Constants.getBoolean(MicroUIProperties.CONSTANT_ON_S3)) {
			// ByteArray.readChar() always uses emb platform endianness whereas the
			// simulator can have another endianness
			return ByteArray.readUnsignedByte(graphicalEngineMetadata, offset);
		} else {
			return ByteArray.readUnsignedByte(graphicalEngineMetadata, offset);
		}
	}
}
