/*
 * Java
 *
 * Copyright 2020-2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microui.display;

/**
 *
 */
public class PainterNatives {

	private PainterNatives() {
		// not entry point
	}

	public static native void writePixel(byte[] sd, int x, int y);

	public static native void drawHorizontalLine(byte[] sd, int x, int y, int width);

	public static native void drawVerticalLine(byte[] sd, int x, int y, int height);

	public static native void drawLine(byte[] sd, int x1, int y1, int x2, int y2);

	public static native void drawRectangle(byte[] sd, int x, int y, int width, int height);

	public static native void fillRectangle(byte[] sd, int x, int y, int width, int height);

	public static native void drawCircleArc(byte[] sd, int x, int y, int diameter, float startAngle, float arcAngle);

	public static native void drawEllipseArc(byte[] sd, int x, int y, int width, int height, float startAngle,
			float arcAngle);

	public static native void fillCircleArc(byte[] sd, int x, int y, int diameter, float startAngle, float arcAngle);

	public static native void fillEllipseArc(byte[] sd, int x, int y, int width, int height, float startAngle,
			float arcAngle);

	public static native void drawEllipse(byte[] sd, int x, int y, int width, int height);

	public static native void fillEllipse(byte[] sd, int x, int y, int width, int height);

	public static native void drawCircle(byte[] sd, int x, int y, int size);

	public static native void fillCircle(byte[] sd, int x, int y, int size);

	public static native void drawRoundedRectangle(byte[] sd, int x, int y, int width, int height, int arcWidth,
			int arcHeight);

	public static native void fillRoundedRectangle(byte[] sd, int x, int y, int width, int height, int arcWidth,
			int arcHeight);

	public static native void drawImage(byte[] destSd, byte[] srcSd, int xSrc, int ySrc, int width, int height,
			int xDest, int yDest, int alpha);

	public static native void drawString(byte[] sd, char[] chars, int offset, int length, byte[] font, int x, int y);

	public static native int stringWidth(char[] chars, int offset, int length, byte[] font);

	/**
	 * Initializes the array allocated by the font (identified by fontData) for the given string.
	 *
	 * @param chars
	 *            the characters array
	 * @param offset
	 *            the offset of the first character
	 * @param length
	 *            the size of string
	 * @param font
	 *            the context that identifies the font
	 * @param renderableString
	 *            the data of the font for this renderable string
	 *
	 * @return the renderable string width
	 */
	public static native int initializeRenderableStringSNIContext(char[] chars, int offset, int length, byte[] font,
			byte[] renderableString);

	/**
	 * Draws the renderable string.
	 *
	 * @param sd
	 *            the destination
	 * @param chars
	 *            the renderable string's characters array
	 * @param offset
	 *            the offset of the first character of the renderable string's characters array
	 * @param length
	 *            the size of renderable string
	 * @param font
	 *            the renderable string's font
	 * @param width
	 *            the renderable string's width in pixels (often useful to draw a string)
	 * @param renderableString
	 *            the font data for this renderable string
	 * @param x
	 *            the X destination
	 * @param y
	 *            the Y destination
	 */
	public static native void drawRenderableString(byte[] sd, // NOSONAR cannot pass object to a native
			char[] chars, int offset, int length, byte[] font, int width, byte[] renderableString, int x, int y);
}
