/*
 * Java
 *
 * Copyright 2009-2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microui.display;

/**
 * This class keeps a reference on the image where the graphics context has been created. The application can loose the
 * the image reference and keep at the same time a reference to the mutableGC. In this case, next call to GC.drawXX must
 * fail.
 *
 * see task M0092MEJAUI-1191
 */
public class MutableImageGraphicsContext extends GraphicsContext {

	public final Image image;

	public MutableImageGraphicsContext(BufferedImage image, int width, int height, Format format) {
		super(image.getSNIContext(), false, format);

		// store the associated buffered image
		this.image = image;
		// have to reset context AFTER setting the image
		reset();
	}

	/**
	 * Force to check if image is not closed calling {@link Image#getSNIContext()}
	 */
	@Override
	public byte[] getSNIContext() {
		return this.image.getSNIContext();
	}
}
