/*
 * Java
 *
 * Copyright 2015-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microui.display;

/**
 * Display resource for Kernel & Features semantic. Physical Display is owned by
 * only one context at a time. Each context has its own {@link Display}
 * resources. The Kernel owns default {@link DisplayFactory} resources. This
 * class represents the Display from a Feature point of view. DisplayPump is
 * shared, but only contains events of the same context at a time.
 */
public class KFDisplayFeature extends Display {

	private final Display kernelDisplay;

	public KFDisplayFeature(Display kernelDisplay) {
		super(new GraphicsContext(kernelDisplay.getGraphicsContext().getSNIContext()));
		this.kernelDisplay = kernelDisplay;
		this.setPump(kernelDisplay.getEventSerializer());
	}

	/**
	 * Gets the kernelDisplay.
	 *
	 * @return the kernelDisplay.
	 */
	public Display getKernelDisplay() {
		return this.kernelDisplay;
	}
}
