/*
 * Java
 *
 * Copyright 2015-2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microui.display;

import ej.microui.AbstractPermission;

/**
 * microUI-API
 */
@SuppressWarnings("nls")
public class ImagePermission extends AbstractPermission {

	private static final long serialVersionUID = 1L;

	/* package */ static final String PERMISSION_CAN_GET = "canget";
	/* package */ static final String PERMISSION_GET = "get";
	/* package */ static final String PERMISSION_CAN_LOAD = "canload";
	/* package */ static final String PERMISSION_LOAD = "load";
	/* package */ static final String PERMISSION_LOAD_FORMAT = "loadwithformat";
	/* package */ static final String PERMISSION_LOAD_INPUTSTREAM = "loadstream";
	/* package */ static final String PERMISSION_LOAD_INPUTSTREAM_FORMAT = "loadstreamwithformat";
	/* package */ static final String PERMISSION_BUFFEREDIMAGE = "create";
	/* package */ static final String PERMISSION_BUFFEREDIMAGE_FORMAT = "createwithformat";

	/**
	 * microUI-API
	 *
	 * @deprecated use {@link #ImagePermission(String)}
	 */
	@Deprecated
	public ImagePermission() {
		// not used
		this(null);
	}

	/**
	 * microUI-API
	 *
	 * @param permission
	 *            a permission
	 */
	public ImagePermission(String permission) {
		super(permission);
	}

}
