/*
 * Java
 *
 * Copyright 2015-2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microui.display;

import ej.microui.AbstractPermission;

/**
 * microUI-API
 */
@SuppressWarnings("nls")
public class FontPermission extends AbstractPermission {

	private static final long serialVersionUID = 1L;

	/* package */ static final String PERMISSION_ADD = "add";
	/* package */ static final String PERMISSION_GET = "get"; // permission not yet in api
	/* package */ static final String PERMISSION_GET_DEFAULT = "getdefault"; // permission not yet in api
	/* package */ static final String PERMISSION_GET_ALL = "getall"; // permission not yet in api

	/**
	 * microUI-API
	 *
	 * @deprecated use {@link #FontPermission(String)}
	 */
	@Deprecated
	public FontPermission() {
		this(PERMISSION_ADD); // backward compatibility
	}

	/***
	 * microUI-API
	 *
	 * @param permission
	 *            a permission
	 */
	public FontPermission(String permission) {
		super(permission);
	}

}
