/*
 * Java
 *
 * Copyright 2010-2025 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microui;

import ej.microui.display.Display;
import ej.microui.display.GraphicsContext;

public interface MicroUIProperties {

	/**
	 * Use EDC property
	 */
	String CONSTANT_USE_SECURITYMANAGER = "com.microej.library.edc.securitymanager.enabled"; //$NON-NLS-1$

	/**
	 * Enable trace logs (system view)
	 */
	String CONSTANT_ENABLE_CORE_LOGS = "core.trace.enabled"; //$NON-NLS-1$

	/**
	 * System MicroUI implementation class
	 */
	String CONSTANT_CLASS_MICROUI_IMPL = "com.microej.library.microui.impl.class"; //$NON-NLS-1$

	/**
	 * True when running on S3
	 */
	String CONSTANT_ON_S3 = "com.microej.library.microui.onS3"; //$NON-NLS-1$

	/**
	 * UI pump's thread priority
	 */
	String CONSTANT_PUMP_PRIORITY = "com.microej.library.microui.pump.priority"; //$NON-NLS-1$

	/**
	 * The system property that gives pump watchdog delay. If not set, default delay is used.
	 */
	String PUMP_WATCHDOG_MAX_DELAY = "com.microej.library.microui.pump.watchdog.delay"; //$NON-NLS-1$

	/**
	 * Property which defines the MicroUI user's fonts files paths.<br>
	 * The paths are separated by the ':' separator. If this property is invalid or not defined, the MicroUI
	 * implementation will not install the user fonts.
	 */
	String FONTS_LIST = "ej.microui.fonts.list"; //$NON-NLS-1$

	/**
	 * Property which defines the MicroUI implementation is allowed to use EDC internal API
	 */
	String EDC_INTERNAL = "com.microej.library.microui.impl.edc-internal"; //$NON-NLS-1$

	/**
	 * Controls the check of drawing error flags when flushing the display.
	 *
	 * If this value is set to <code>true</code>, {@link Display#flush(boolean)} will throw a {@link MicroUIException}
	 * if an error was reported during a drawing operation.
	 *
	 * If set to <code>false</code>, {@link Display#flush(boolean)} will not throw, and the drawing log flags will not
	 * be cleared. Their value may still be checked with {@link GraphicsContext#getAndClearDrawingLogFlags()} and
	 * {@link GraphicsContext#checkDrawingLogFlags()}.
	 */
	String CHECK_DRAWING_ERRORS_ON_FLUSH = "com.microej.library.microui.impl.check-drawing-errors-on-flush"; //$NON-NLS-1$

	/**
	 * {@link #FONTS_LIST} separator
	 */
	char FONTS_LIST_SEPARATOR = ':';
}
