/*
 * Java
 *
 * Copyright 2010-2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microui;

import ej.error.ErrorMessages;

/**
 * MicroUI Error messages
 */

public class MicroUIErrorMessages implements ErrorMessages {

	@Override
	public String category() {
		return "MicroUI"; //$NON-NLS-1$
	}

	@Override
	public String messageAt(int index) {
		switch (index) {
		case MicroUIException.INTERN_NO_MICROUI_IMPL:
			return "Issue when loading SystemMicroUI implementation class."; //$NON-NLS-1$
		case MicroUIException.MICROUI_NOT_STARTED:
			return "MicroUI not started."; //$NON-NLS-1$
		case MicroUIException.GENERIC_EVENT_GENERATOR_INVALID_CLASSNAME:
			return "[Warning] The generic event generator specified in the VEE Port configuration file 'microui.xml' is not available in the application classpath."; //$NON-NLS-1$
		case MicroUIException.DISPLAY_DEADLOCK:
			return "Cannot wait for an event in the same thread that treats events (Deadlock)."; //$NON-NLS-1$
		case MicroUIException.RESOURCE_INVALID_PATH:
			return "The resource cannot be retrieved. Path must be relative to the application classpath and starts with '/'."; //$NON-NLS-1$
		case MicroUIException.RESOURCE_INVALID_FILE:
			return "The resource content cannot be read for any reason."; //$NON-NLS-1$
		case MicroUIException.RESOURCE_CLOSED:
			return "The resource has been closed. Application cannot use this resource anymore."; //$NON-NLS-1$
		case MicroUIException.IMAGE_OUT_OF_MEMORY:
			return "Not enough space in images heap to allocate the Image's native data."; //$NON-NLS-1$
		case MicroUIException.IMAGE_UNKNOWN_FORMAT:
			return "Cannot decode this kind of image because there is no runtime decoder able to decode this image."; //$NON-NLS-1$
		case MicroUIException.OUT_OF_EVENTS:
			return "Events queue is full, cannot add new event."; //$NON-NLS-1$
		case MicroUIException.NO_DISPLAY:
			return "There is no display on this platform, cannot use classes in package ej.microui.display."; //$NON-NLS-1$
		case MicroUIException.NO_FONT:
			return "There is no font (platform and application), cannot draw something which requires a font."; //$NON-NLS-1$
		case MicroUIException.EVENTGENERATOR_POOL_FULL:
			return "Maximum of EventGenerators in system pool reached (max 254)."; //$NON-NLS-1$
		case MicroUIException.IMAGE_UNSUPPORTED_FORMAT:
			return "Cannot create image or graphics with this format because it is not supported."; //$NON-NLS-1$
		case MicroUIException.DRAWING_ERROR:
			return "A drawing operation reported an error. See the drawing log flags for more information."; //$NON-NLS-1$
		default:
			return "Unknown error " + index; //$NON-NLS-1$
		}
	}
}
