/*
 * Java
 *
 * Copyright 2019-2025 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microui;

import com.is2t.microbsp.microui.natives.NSystemDisplay;
import com.is2t.microbsp.microui.natives.NSystemLedsImpl;
import com.is2t.microbsp.microui.natives.NSystemPump;

import ej.bon.Constants;
import ej.trace.Tracer;

/**
 *
 */
public class Log {

	/**
	 * Unique instance of the MicroUI tracer. Never null.
	 */
	public static Tracer Instance;

	/**
	 * EVENTS
	 */

	public static final int EXECUTE_EVENTGENERATOR_EVENT = 0;

	public static final int EXECUTE_DROP_EVENT = 1;

	public static final int EXECUTE_INPUT_EVENT = 2;

	public static final int EXECUTE_DISPLAY_EVENT = 3;

	public static final int EXECUTE_USER_EVENT = 4;

	public static final int OPEN_IMAGE = 5;

	public static final int IMAGE_CARACTERISTICS = 6;

	private static final int NB_EVENTS = 140; // see SYSVIEW_MicroUI.txt

	/**
	 * EVENTS TYPES
	 */

	public static final int TYPE_OPEN_IMAGE_MUTABLE = 0;
	public static final int TYPE_OPEN_IMAGE_FROM_PATH = 1;
	public static final int TYPE_OPEN_IMAGE_FROM_INPUTSTREAM = 2;

	// TYPE_OPEN_IMAGE_MUTABLE
	public static final int IMAGE_CARACTERISTICS_NEW_IMAGE = 0;

	// TYPE_OPEN_IMAGE_FROM_PATH
	public static final int IMAGE_CARACTERISTICS_INTERNAL_RAW = 1;
	public static final int IMAGE_CARACTERISTICS_INTERNAL_DYNAMIC = 2;
	public static final int IMAGE_CARACTERISTICS_EXTERNAL_RAW = 3;
	public static final int IMAGE_CARACTERISTICS_EXTERNAL_DYNAMIC = 4;

	// TYPE_OPEN_IMAGE_FROM_INPUTSTREAM
	public static final int IMAGE_CARACTERISTICS_MEMORYINPUTSTREAM = 5;
	public static final int IMAGE_CARACTERISTICS_BYTEARRAYINPUTSTREAM = 6;
	public static final int IMAGE_CARACTERISTICS_GENERICINPUTSTREAM = 7;

	// NSystemDisplay.linkImage()
	@Deprecated
	public static final int IMAGE_CARACTERISTICS_LINK_IMAGE = 8;

	private Log() {
		// not entry point
	}

	/**
	 * Creates the MicroUI tracer.
	 */
	public static void create() {
		// create the instance event if the traces are disabled (prevent NPE)
		Instance = new Tracer("MicroUI", NB_EVENTS); //$NON-NLS-1$

		if (Constants.getBoolean(Tracer.TRACE_ENABLED_CONSTANT_PROPERTY)) {
			// give this logger to native side.
			int groupID = Instance.getGroupID();
			NSystemDisplay.setTraceGroupID(groupID);
			NSystemPump.setTraceGroupID(groupID);
			NSystemLedsImpl.setTraceGroupID(groupID);
		}
	}

}
