/*
 * Java
 *
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microui;

import java.security.BasicPermission;
import java.security.Permission;

/**
 * MicroUI permissions (font, image, display, event and microui) extend {@link Permission} in the API and by consequence
 * cannot extends {@link BasicPermission} in the implementation (apidiff checker error).
 *
 * This class copies the behavior of EDC {@link BasicPermission}.
 */
@SuppressWarnings("serial")
public abstract class AbstractPermission extends Permission {

	/**
	 * Constructs a permission with the specified name.
	 *
	 * @param name
	 *            the name of the Permission object being created.
	 */
	protected AbstractPermission(String name) {
		super(name);
	}

	@Override
	public boolean equals(Object obj) {
		if (obj != null && getClass() == obj.getClass()) {
			AbstractPermission permission = (AbstractPermission) obj;
			return getName().equals(permission.getName());
		}
		return false;

	}

	@Override
	public String getActions() {
		// the name is the action
		return getName();
	}

	@Override
	public int hashCode() {
		return getName().hashCode();
	}

	@Override
	public boolean implies(Permission p) {
		if (p.getClass() != getClass()) {
			return false;
		}
		return getName().equals(p.getName());
	}

}
