/*
 * Java
 *
 * Copyright 2010-2025 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.is2t.microbsp.microui.natives;

public class NSystemPump {

	private NSystemPump() {
		// not entry point
	}

	public static native void initialize();

	/**
	 * Configures the log group for the event engine
	 *
	 * @param groupID
	 *            MicroUI group identifier
	 */
	public static native void setTraceGroupID(int groupID);

	public static native void start();

	public static native boolean add(int event);

	public static native int read();

	public static native void interrupt();

	public static native void clearQueue();

	public static native int getEvent();

	/**
	 * Checks if a Kernel event with the given mask already exists.
	 *
	 * @param mask
	 *            the Kernel event mask
	 * @return the previous Kernel event, or <code>0</code> if none.
	 */
	public static native int getKernelEvent(int mask);

	/**
	 * Reset all events of the queue and add the new Kernel event as the single event of the queue.
	 *
	 * @param newEvent
	 *            the new Kernel event
	 */
	public static native void addKernelEvent(int newEvent);

	/**
	 * Replaces the current Kernel event slot with the new Kernel event.
	 *
	 * @param newEvent
	 *            the new Kernel event
	 */
	public static native void replaceKernelEvent(int newEvent);

}
