/*
 * Java
 *
 * Copyright 2010-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.is2t.microbsp.microui.geg;

import com.is2t.microbsp.microui.natives.NSystemStates;

import ej.microui.MicroUIPump;
import ej.microui.SystemMicroUI;
import ej.microui.event.EventHandler;
import ej.microui.event.generator.States;

/**
 * Instance created by SystemMicroUIGenerator
 */
public class SystemStates extends States {

	private boolean haveToInitialize; // false init

	/**
	 * @param nbValues
	 *            see API States
	 * @param initialValues
	 *            see API States
	 */
	public SystemStates(int[] nbValues, int[] initialValues) {
		super(nbValues, initialValues);
	}

	/**
	 * There is no default values; need to get the initial values from native world
	 *
	 * @param nbValues
	 *            see API States
	 */
	public SystemStates(int[] nbValues) {
		this(nbValues, new int[nbValues.length]/* 0 init */);
		this.haveToInitialize = true;
	}

	@Override
	public int addToSystemPool() {
		int id = super.addToSystemPool();
		if (this.haveToInitialize) {
			for (int i = getNumberOfStates(); --i >= 0;) {
				send(i, NSystemStates.getInitialStateValue(id, i));
			}
			this.haveToInitialize = false;
		}
		return id;
	}

	/*
	 * The format of the input for states generator is defined by the MicroUI
	 * specification. It is the same format as the MicroUI event format.
	 */
	@Override
	public void convert(MicroUIPump pump, int inputEvent, EventHandler eventHandler) {

		// update state
		update(getStateId(inputEvent), getStateValue(inputEvent));

		// native input states event has same format than MicroUI state event:
		// -> just replace "input event" by "state event"
		sendEvent(SystemMicroUI.buildEvent(getEventType(), SystemMicroUI.getData(inputEvent)), eventHandler);
	}
}
