/*
 * Java
 *
 * Copyright 2009-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.is2t.microbsp.microui.geg;

import ej.microui.MicroUIPump;
import ej.microui.SystemMicroUI;
import ej.microui.event.EventHandler;
import ej.microui.event.generator.Pointer;

/**
 * Instance created by SystemMicroUIGenerator
 */
public class SystemPointer extends Pointer {

	/**
	 * Driver MicroEJ specific:
	 * <p>
	 * event0: PPPP PPPP EEEE EEEE [button event]<br>
	 * event1: t--- xxxx xxxx xxxx ---- yyyy yyyy yyyy<br>
	 * <p>
	 * where
	 * <ul>
	 * <li>P is the pump native event (0x7)</li>
	 * <li>E it the EventGenerator id</li>
	 * <li>t is the type absolute or relative</li>
	 * <li>x is x</li>
	 * <li>y is y</li>
	 * </ul>
	 */
	// masks & shifts
	private static final int DRIVER_TYPE_SHIFT = 31;
	private static final int DRIVER_TYPE_MASK = 0x1 << DRIVER_TYPE_SHIFT;
	private static final int DRIVER_X_SHIFT = 16;
	private static final int DRIVER_X_MASK = 0xfff << DRIVER_X_SHIFT;
	private static final int DRIVER_Y_SHIFT = 0;
	private static final int DRIVER_Y_MASK = 0xfff << DRIVER_Y_SHIFT;

	// types values
	private static final int DRIVER_TYPE_DELTA = 0x1; // 0 means ABS

	/**
	 * There is only one pointer event converter per native pointer. if the given id
	 * is invalid or has been already set, throw runtime
	 *
	 * @param nbButtons
	 *            available number of extended buttons
	 * @param width
	 *            area width
	 * @param height
	 *            area height
	 */
	public SystemPointer(int nbButtons, int width, int height) {
		super(nbButtons, width, height);
	}

	@Override
	public void convert(MicroUIPump pump, int inputEvent, EventHandler eventHandler) throws InterruptedException {

		// read next event
		int xy = pump.read();

		// manage x coordinate & absolute or relative
		int x = (xy & DRIVER_X_MASK) >>> DRIVER_X_SHIFT;
		int y = (xy & DRIVER_Y_MASK) >>> DRIVER_Y_SHIFT;

		if (((xy & DRIVER_TYPE_MASK) >>> DRIVER_TYPE_SHIFT) == DRIVER_TYPE_DELTA) {
			x = getAbsoluteX() + (short) x; // x is on 16 bits for sure
			y = getAbsoluteY() + (short) y; // y is on 16 bits for sure
		}

		int cmd = getAction(inputEvent);

		if (RELEASED != cmd) {
			// update pointer position
			reset(x, y);
		}

		if (MOVED == cmd) {
			send(buildEvent(getButtonsState() == 0 ? MOVED : DRAGGED, 0), eventHandler);
		} else {
			send(SystemMicroUI.buildEvent(getEventType(), SystemMicroUI.getData(inputEvent)), eventHandler);
		}
	}
}
