/*
 * Java
 *
 * Copyright 2009-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.is2t.microbsp.microui.geg;

import ej.microui.MicroUIPump;
import ej.microui.SystemMicroUI;
import ej.microui.event.EventHandler;
import ej.microui.event.generator.Command;

/**
 * Instance created by SystemMicroUIGenerator.
 */
public class SystemCommand extends Command {

	/**
	 *
	 */
	public SystemCommand() {
		super();
	}

	/*
	 * The format of the input for command generator is defined by the MicroUI
	 * specification. It is the same format as the MicroUI event format.
	 */
	@Override
	public void convert(MicroUIPump pump, int inputEvent, EventHandler eventHandler) {
		// native input button event has same format than MicroUI command event:
		// -> just replace "input event" by "command event"
		sendEvent(SystemMicroUI.buildEvent(getEventType(), SystemMicroUI.getData(inputEvent)), eventHandler);
	}
}
