/*
 * Java
 *
 * Copyright 2009-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.is2t.microbsp.microui.geg;

import ej.microui.MicroUIPump;
import ej.microui.SystemMicroUI;
import ej.microui.event.EventHandler;
import ej.microui.event.generator.Buttons;

/**
 * Instance created by SystemMicroUIGenerator
 */
public class SystemButtons extends Buttons {

	/**
	 * @param nbButtons
	 *            available number of extended buttons
	 */
	public SystemButtons(int nbButtons) {
		super(nbButtons);
	}

	/*
	 * The format of the input for buttons generator is defined by the MicroUI
	 * specification. It is the same format as the MicroUI event format.
	 */
	@Override
	public void convert(MicroUIPump pump, int event, EventHandler eventHandler) {
		// native input button event has same format than MicroUI button event:
		// -> just replace "input event" by "button event"
		send(SystemMicroUI.buildEvent(getEventType(), SystemMicroUI.getData(event)), eventHandler);
	}

}
