/*
 * Java
 *
 * Copyright 2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.pump._int;

/**
 *
 */
public class QueuedIntPump extends IntPump {

	private final BlockingIntQueue queue;
	private final IntHandler handler;

	public QueuedIntPump(BlockingIntQueue queue, IntHandler handler) {
		if (queue == null || handler == null) {
			throw new NullPointerException();
		}
		this.queue = queue;
		this.handler = handler;
	}

	@Override
	public int read() throws InterruptedException {
		return this.queue.poll();
	}

	@Override
	protected void execute(int data) {
		this.handler.execute(data);
	}

	@Override
	public void stop() {
		super.stop();
	}

}
