/*
 * Java
 *
 * Copyright 2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.pump._int;

/**
 * A int handler is used to execute int data.
 */
public interface IntHandler {

	/**
	 * Executes the given data.
	 * <p>
	 * This method is called by the {@link QueuedIntPump} when a data is read.
	 *
	 * @param data
	 *            the data to execute.
	 */
	void execute(int data);

}
