/*
 * Java
 *
 * Copyright 2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.pump._int;

import java.util.Collection;

/**
 * A queue that waits for the queue to contain some elements (at least one) when retrieving an element.
 */
public interface BlockingIntQueue {

	/**
	 * Adds a new value in the queue.
	 *
	 * @param value
	 *            the new value to be added to the queue.
	 * @return <code>true</code> (as specified by {@link Collection#add}).
	 * @throws IllegalStateException
	 *             if their is not enough space in the queue.
	 */
	boolean add(int value) throws IllegalStateException;

	/**
	 * Adds a new value in the queue.
	 *
	 * @param value
	 *            the new value to be added to the queue.
	 * @return <code>true</code> if the element is added to the queue, <code>false</code> if their is not enough space
	 *         in the queue.
	 */
	boolean offer(int value);

	/**
	 * Gets the head of this queue, or blocks until data is available.
	 *
	 * @return the head of this queue.
	 * @throws InterruptedException
	 *             if interrupted while waiting.
	 */
	int poll() throws InterruptedException;

}
