/*
 * Java
 *
 * Copyright 2019-2023 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.kf;

import ej.kf.Feature;

/**
 * Native methods implemented by S3.
 */
public class DynamicLoaderNatives {

	/**
	 * VM Known.
	 *
	 * @see KernelNatives#loadStaticFeatureByName(char[], int)
	 */
	public static final int ERROR_LOADSTATIC_ALREADYLOADED = -1;

	/**
	 * VM Known.
	 *
	 * @see KernelNatives#loadStaticFeatureByName(char[], int)
	 */
	public static final int ERROR_LOADSTATIC_NOT_FOUND = -2;

	public static native int openDynamicFeatureTransfer();

	public static native int closeDynamicFeatureTransfer(int id);

	public static native void transferDynamicFeature(int id, byte[] data, int length);

	public static native boolean unloadDynamicFeature(Feature feature);

	/**
	 * Load a statically linked Feature from its internal name given at SOAR time.
	 *
	 * @return the featureSection descriptor (>=0) or an error (see
	 *         ERROR_LOADSTATIC_XXX error codes)
	 */
	public static native long loadStaticFeatureByName(char[] name, int length);

	/**
	 * Get the maximum number of Features that have been installed within this
	 * firmware (post-link)
	 *
	 * @return a positive integer
	 */
	public static native int getMaxNbInstalledFeatures();

	/**
	 * Get the featureSectionDescriptor of the installed Feature at the given offset
	 *
	 * @param offset between
	 *               <code>0 and </code>{@link #getMaxNbInstalledFeatures()}-1</code>
	 * @return a featureSectionDescriptor or -1 if there is no installed
	 *         {@link Feature} at the given slot
	 */
	public static native long getInstalledFeatureDescriptor(int offset);

}
