/*
 * Java
 *
 * Copyright 2008-2023 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.kf.elflw;

import com.is2t.kf.MemoryBlock;

/**
 * Dynamic section (i.e. physical size is 0)
 */
public class DynamicAllocationSection extends Section implements AllocationSection {

	private final MemoryBlock data;

	public DynamicAllocationSection(MemoryBlock data) {
		this.data = data;
	}

	@Override
	public int size() {
		return 0;
	}

	@Override
	public int memSize() {
		return this.data.getSize();
	}

	@Override
	public MemoryBlock getMemoryBlock() {
		return this.data;
	}

	@Override
	public long getRelocatedAddress() {
		return this.data.getAddress();
	}

}
