/*
 * Java
 *
 * Copyright 2008-2023 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.kf.elflw;

import com.is2t.kf.MemoryBlock;

/**
 * Common super type for all ELF sections that are a part of the program Not a ELF control section This kind of section
 * can be a part of a Segment
 */
public interface AllocationSection {

	/**
	 * @return the allocated memory block descriptor
	 */
	public MemoryBlock getMemoryBlock();

	/**
	 * @return the size of the section at runtime
	 */
	public int memSize();

	/**
	 * @return the address where this section will be linked
	 */
	public long getRelocatedAddress();
}
