/*
 * Java
 *
 * Copyright 2022-2023 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.kf;

/**
 * A {@link MemoryBlock} mapped to a ROM address. Only the data transfer is implemented (no read operation).
 */
public class ROMBlock implements MemoryBlock {

	private final long startAddress;
	private final int size;

	public ROMBlock(long startAddress, int size) {
		this.startAddress = startAddress;
		this.size = size;
	}

	@Override
	public int getSize() {
		return this.size;
	}

	@Override
	public boolean copyByteArrayToMemory(byte[] src, int srcOffset, int dstOffset, int length) {
		return DynamicLoaderNatives.copyByteArrayToROM(this.startAddress + dstOffset, src, srcOffset, length);
	}

	@Override
	public void copyMemoryToByteArray(int srcOffset, byte[] dst, int dstOffset, int length) {
		throw new AssertionError();
	}

	@Override
	public long getAddress() {
		return this.startAddress;
	}

}
