/*
 * Java
 *
 * Copyright 2015-2023 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.kf;

public class RAMBlock implements MemoryBlock {

	public final long memoryBlockDescriptor;
	private final long sectionStartAddress;
	private final int size;

	public RAMBlock(long memoryBlockDescriptor, long sectionStartAddress, int size) {
		this.memoryBlockDescriptor = memoryBlockDescriptor;
		this.sectionStartAddress = sectionStartAddress;
		this.size = size;
	}

	@Override
	public int getSize() {
		return this.size;
	}

	@Override
	public boolean copyByteArrayToMemory(byte[] src, int srcOffset, int dstOffset, int length) {
		return DynamicLoaderNatives.copyByteArrayToRAM(this.memoryBlockDescriptor, src, srcOffset, dstOffset, length);
	}

	@Override
	public void copyMemoryToByteArray(int srcOffset, byte[] dst, int dstOffset, int length) {
		if (!DynamicLoaderNatives.copyRAMToByteArray(this.memoryBlockDescriptor, srcOffset, dst, dstOffset, length)) {
			throw new ArrayIndexOutOfBoundsException();
		}
	}

	@Override
	public long getAddress() {
		return this.sectionStartAddress;
	}
}
