/*
 * Java
 *
 * Copyright 2022-2023 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.is2t.kf;

import ej.kf.InvalidFormatException;
import ej.kf.Kernel;

/**
 * Error constants of {@link InvalidFormatException} thrown by this loader.
 */
public interface InvalidFormatConstants {

	/**
	 * Category of errors related to a wrong <code>LLKERNEL</code> implementation or memory limits reached.
	 */
	public static final int USER_ERROR = InvalidFormatException.FIRST_SPECIFIC_ERROR;

	/**
	 * The <code>LLKERNEL_impl_copyToROM<code> returned an error.
	 */
	public static final int UNEXPECTED_COPY_ERROR = USER_ERROR + 1;

	/**
	 * The maximum number of installed Features is reached.
	 */
	public static final int TOO_MANY_INSTALLED_FEATURES = USER_ERROR + 2;

	/**
	 * The installed Feature content is corrupted (bad CRC check).
	 */
	public static final int CORRUPTED_INSTALLED_FEATURE = USER_ERROR + 3;

	/**
	 * The address returned by the last call to <code>LLKERNEL_impl_getFeatureAddressRAM</code> or
	 * <code>LLKERNEL_impl_getFeatureAddressROM</code> does not match the alignment constraint.
	 */
	public static final int INVALID_AREA_START_ADDRESS_ALIGNMENT = USER_ERROR + 4;

	/**
	 * The address returned by the last call to <code>LLKERNEL_impl_getFeatureAddressROM</code> overlaps with a
	 * previously returned address.
	 */
	public static final int OVERLAP_ROM_AREA = USER_ERROR + 5;

	/**
	 * The address returned by the last call to <code>LLKERNEL_impl_getFeatureAddressRAM</code> overlaps with a
	 * previously returned address.
	 */
	public static final int OVERLAP_RAM_AREA = USER_ERROR + 6;

	/**
	 * The address returned by the last call to <code>LLKERNEL_impl_getFeatureAddressRAM</code> is not the same than the
	 * one returned when Feature has been installed.
	 */
	public static final int RAM_ADDRESS_CHANGED = USER_ERROR + 7;

	/**
	 * The <code>.fo</code> file cannot be installed on this Kernel because it contains a code chunk section with a size
	 * greater than this Kernel code chunk size.
	 */
	public static final int FEATURE_CODE_CHUNK_TOO_SMALL = USER_ERROR + 8;

	/**
	 * The <code>LLKERNEL_IMPL_allocateFeature<code> returned <code>0</code>. The Feature cannot be allocated in memory.
	 */
	public static final int FEATURE_ALLOCATION_ERROR = USER_ERROR + 9;

	/**
	 * The <code>LLKERNEL_IMPL_getFeatureHandle<code> returned <code>0</code>. The Feature cannot be allocated in
	 * memory.
	 */
	public static final int FEATURE_NULL_HANDLE = USER_ERROR + 10;

	/**
	 * Errors that should not occur with a valid Feature file. <br>
	 * When one on the following error is encountered, most likely the <code>.fo</code> file passed to
	 * {@link Kernel#install(java.io.InputStream)} is corrupted.
	 */
	public static final int INVALID_FO_ERROR = InvalidFormatException.FIRST_SPECIFIC_ERROR + 100; // VM known
	public static final int INVALID_FO_WRONG_ELF_CLASS = INVALID_FO_ERROR + 1;
	public static final int INVALID_FO_WRONG_ELF_ENDIANNESS = INVALID_FO_ERROR + 2;
	public static final int INVALID_FO_WRONG_ELF_VERSION = INVALID_FO_ERROR + 3;
	public static final int INVALID_FO_WRONG_ELF_TYPE = INVALID_FO_ERROR + 4;
	public static final int INVALID_FO_WRONG_ELF_MACHINE = INVALID_FO_ERROR + 5;
	public static final int INVALID_FO_WRONG_SECTION_HEADER = INVALID_FO_ERROR + 6;
	public static final int INVALID_FO_WRONG_SECTION_NUM = INVALID_FO_ERROR + 7;
	public static final int INVALID_FO_WRONG_SECTION_NAMES = INVALID_FO_ERROR + 8;
	public static final int INVALID_FO_WRONG_SYMBOL_TABLE_SECTION_SIZE = INVALID_FO_ERROR + 9;
	public static final int INVALID_FO_WRONG_SYMBOL_TABLE_SECTION_COUNT = INVALID_FO_ERROR + 10;
	public static final int INVALID_FO_WRONG_SYMBOL_TABLE_SECTION_MISSING = INVALID_FO_ERROR + 11;
	public static final int INVALID_FO_WRONG_NOBITS_SECTION_FLAG = INVALID_FO_ERROR + 12;
	public static final int INVALID_FO_WRONG_UNKNOWN_SECTION_TYPE = INVALID_FO_ERROR + 13;
	public static final int INVALID_FO_NEGATIVE_PADDING = INVALID_FO_ERROR + 14;
	public static final int INVALID_FO_UNKNOWN_SYMBOL = INVALID_FO_ERROR + 15;
	public static final int INVALID_FO_UNDEFINED_SYMBOL = INVALID_FO_ERROR + 16;
	public static final int INVALID_FO_RELOCATION_ERROR1 = INVALID_FO_ERROR + 17; // VM known
	public static final int INVALID_FO_RELOCATION_ERROR2 = INVALID_FO_ERROR + 18; // VM known

}
